/* hangul.h */

#ifndef _HANGUL_H
#define _HANGUL_H

#include <stdio.h>

#undef TRUE 
#define TRUE 1
#undef FALSE
#define FALSE 0

#define DEFAULT_FONT 0
#define USER_FONT 1

#define IS_LOW_ASC	0        /* 127  ƽŰ ڵ      */ 
#define IS_HIGH_ASC 1        /* 128 ̻ ƽŰ ڵ      */ 
#define IS_ENGLISH	0        /*  Ʈ ڵ        */
#define IS_HANGUL_FIRST  1   /*  Ʈ ѱ ù°ڵ */
#define IS_HANGUL_SECOND 2   /*  Ʈ ѱ °ڵ */

#define HAN_ENG_MODE 0       /* ѱۿ Է 迭÷ */
#define HAN_JAPAN 1          /* ι-  迭÷ */
#define HAN_CODE 2           /* -ϼ Է» 迭÷ */

#define ENG_INPUT 0          /*  Է */
#define HAN_INPUT 1          /* ѱԷ */ 
#define DUBEL_TYPE 0         /* ι */
#define SEBEL_TYPE 1         /*  */
#define KS5061_CODE 0        /* ϼ */
#define JOHAP_CODE 1         /*  */

/* ѱǺƾ ϴ ũ  */
#define CODE_ENGLISH 0       /*  ڵ */
#define CODE_KS5061 1        /* ϼ ڵ */
#define CODE_JOHAP 2         /*  ڵ */

/* Hangul strings use 'unsinged char' instead of 'char'. */ 
/* Almost system understand 'char' to 'unsigned char',  */
/* but some systems  not.                               */                  

typedef unsigned char byte;

/* Hangul Automata buffer structure */
typedef struct {
  int currentHanState;
  int key;
  int unionCode;
} _inStack;

/* Variable about hangul Automata */
extern _inStack inStack[];
extern int outStack[];
extern int inSP;
extern int outSP;
extern int tempHanState;

extern byte HanFont1[8][20][32];
extern byte HanFont2[4][22][32];
extern byte HanFont3[4][28][32];
extern byte EngFont[][16];

/* hangul or english, keyboard type, ks5061 or Johap code */
extern int hanMode[];

extern int GL_X_POSITION;    /* Global X Position */
extern int GL_Y_POSITION;    /* Global Y Position */
extern int GL_FG_COLOR;      /* Global Foreground Color */
extern int GL_BG_COLOR;      /* Global Background Color */

#define hanAutomata(x) hanMode[HAN_JAPAN] ? hanAutomata3(x) : hanAutomata2(x)

/*  hangul image functions */
void or_image(byte *s1, byte *s2, int len);
void *get_han_image(byte first, byte second);
void *get_eng_image(byte c);
void *han_bit_image(byte *image, int fg, int bg);
void *eng_bit_image(byte *image, int fg, int bg);
void han_image_view(int x, int y, byte *image);
void eng_image_view(int x, int y, byte *image); 

/* hangul init.. functions */
void hinitgraph(int mode, char *han, char *eng, int font_mothod);
void hloadfont(char *hanfontname, char *engfontname);
void hclosegraph(); 

/* hangul output functions */
int hputch(int ch);
int hputchxy(int x, int y, int fg, int bg, int ch);
void hputs(byte *str);
void hputsxy(int x, int y, int fg, int bg, byte *str);
int hprintf(char *format, ...);
int hprintfxy(int x, int y, int fg, int bg, char *format, ...);

/* hangul input functions */
int hanAutomata2(int key);
int hanAutomata3(int key);
int hgetch(void);
int hgetchn(void);
int hgetkey();
void hputkey(int key);
int hinkeybuf(void);
int hconvertkey(int key);
int hgets(byte *str, int maxlen);
int hgetsxy(int x, int y, int fg, int bg, byte *str, int maxlen);

/* hangul etc functions */
int ishangul(byte *str, int index);

#endif  /* hangul.h */
