
////////(Copyright)/////////////////////////
//
//     Autor: Antonio Castro Snurmacher 
//     (E-mail <acastro@ctv.es> )
//
//  Este fuente puede ser utilizado, distri-
//  buido, y modificado libremente pero
//  siempre se deber respetar la propiedad
//  intelectual de su autor. El autor renun-
//  cia a todo tipo de beneficio econmico y
//  no se hace responsable de los posibles
//  perjuicios derivados del uso del mismo.
//  Toda modificacin queda sujeta a las
//  mismas condiciones de uso que el origi-
//  nal. En caso de traduccin deber con-
//  servarse el texto original de esta cabe-
//  cera y aadirse la traduccin a conti-
//  nuacin de ella. 
//  
////////////////////////////////////////////

//------------------------------------------
//    'Libro.inc'   (dd-mmmm-19aa)
//------------------------------------------
//  Esta versin esta dedicada a su inclu-
//  sin en la revista LinuxFocus.
//------------------------------------------


//////////////////////////////////////////
// LargoLibro, AnchoLibro, GruesoLibro
// PortadaLibro, y LomoLibro deben de 
// estar previamente declarados.
//
// Ejemplo:
//
//#declare LargoLibro   = 20;
//#declare AnchoLibro   = 12;
//#declare GruesoLibro  = 3.5;
//#declare PortadaLibro = 
//                 "scan_gif/bookp2.gif"
//#declare LomoLibro    = 
//                 "scan_gif/bookl2.gif"
//////////////////////////////////////////

#declare Epsil =   0.0001;

#declare TextureLibro = texture {
 pigment {
    gradient z
    color_map { 
       [0.0 colour White ]
       [0.1 colour Gray90 ]
       [0.2 colour White ]
       [0.3 colour Gray95 ]
       [0.4 colour White ]
       [0.5 colour Gray80 ]
       [0.6 colour White ]
       [0.6 colour Gray95 ]
       [0.8 colour White ]
       [0.9 colour Gray90 ]
       [1.0 colour Gray85 ]
    } // end colourmap
  } // end pigment
  finish { ambient 0.3 diffuse 0.7 }
  scale <1, 1, 0.3>
} // end Texture


#declare Libro = object {
  union {

      box { <0, 0, 0> <1,1,1>
         texture { TextureLibro }
         translate <-0.5, -0.5, -0.5>
      }

      // Portada del libro
      box { <0,0, 0>  <1, 1, 1>   
         texture { 
            pigment{ 
               image_map { 
                  gif PortadaLibro once 
               } 
            } 
          } 
         translate <-0.5, -0.5, -0.5>
         scale <1-Epsil, 1-Epsil, 1+Epsil>
       } // end box

       // Lomo del libro
       box { <0,0,0 >   <1 ,1 ,1 >
         texture { 
            pigment{ 
               image_map { 
                  gif LomoLibro once 
                } 
            } 
         } 
         translate <-0.5, -0.5, -0.5>
         scale <1-Epsil, 1-Epsil, 1+Epsil>
         rotate y*90
       } // end box
     } // end union
  translate <-0.5, -0.5, -0.5> // Centrar el cubo en <0,0,0>
  scale <AnchoLibro, LargoLibro, GruesoLibro>
} // Fin 'Libro.inc'

