/*
   io8534.h - internal register definitions for AT90C8534

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   Based on preliminary Atmel datasheet Rev. 1229A-04/99.
 */

#ifndef __IO8534
#define __IO8534 1

/* I/O space addresses */

/* 0x00..0x03 reserved */

/* ADC Data Register */
#define ADCL	0x04
#define ADCH	0x05

/* ADC Control and Status Register */
#define ADCSR	0x06

/* ADC Multiplexer Select Register */
#define ADMUX	0x07

/* 0x08..0x0F reserved */

/* General Interrupt Pin Register */
#define GIPR 0x10

/* 0x11..0x19 reserved */

/* Data Direction Register, Port A */
#define DDRA	0x1A

/* Data Register, Port A */
#define PORTA	0x1B

/* EEPROM Control Register */
#define EECR	0x1C

/* EEPROM Data Register */
#define EEDR	0x1D

/* EEPROM Address Register */
#define EEARL	0x1E
#define EEARH	0x1F

/* 0x20..0x2B reserved */

/* Timer/Counter1 */
#define TCNT1L	0x2C
#define TCNT1H	0x2D

/* Timer/Counter1 Control Register */
#define TCCR1	0x2E

/* 0x2F..0x31 reserved */

/* Timer/Counter0 (8-bit) */
#define TCNT0	0x32

/* Timer/Counter0 Control Register */
#define TCCR0	0x33

/* 0x34 reserved */

/* MCU general Control Register */
#define MCUCR	0x35

/* 0x36..0x37 reserved */

/* Timer/Counter Interrupt Flag Register */
#define TIFR	0x38

/* Timer/Counter Interrupt MaSK Register */
#define TIMSK	0x39

/* General Interrupt Flag Register */
#define GIFR	0x3A

/* General Interrupt MaSK register */
#define GIMSK	0x3B

/* 0x3C reserved */

/* Stack Pointer */
#define SPL	0x3D
#define SPH	0x3E

/* Status REGister */
#define SREG	0x3F

/* Interrupt vectors (byte addresses) */

#define SIG_INTERRUPT0		_vector_1
#define SIG_INTERRUPT1		_vector_2
#define SIG_OVERFLOW1		_vector_3
#define SIG_OVERFLOW0		_vector_4
#define SIG_ADC			_vector_5
#define SIG_EEPROM_READY	_vector_6

#define END_VECTOR		(6)
#define INT_VECT_SIZE (0x0e)

/*
/* Bit numbers */

/* GIMSK */
#define INT1	7
#define INT0	6

/* GIFR */
#define INTF1	7
#define INTF0	6

/* GIPR */
#define IPIN1	3
#define IPIN0	2

/* TIMSK */
#define TOIE1	2
#define TOIE0	0

/* TIFR */
#define TOV1	2
#define TOV0	0

/* MCUCR */
#define SE	6
#define SM	5
#define ISC1	2
#define ISC0	0

/* TCCR0 */
#define CS02	2
#define CS01	1
#define CS00	0

/* TCCR1 */
#define CS12	2
#define CS11	1
#define CS10	0

/* EECR */
#define EERIE	3
#define EEMWE	2
#define EEWE	1
#define EERE	0

/* PORTA */
#define PA7	7
#define PA6	6
#define PA5	5
#define PA4	4
#define PA3	3
#define PA2	2
#define PA1	1
#define PA0	0

/* DDRA */
#define DDA7	7
#define DDA6	6
#define DDA5	5
#define DDA4	4
#define DDA3	3
#define DDA2	2
#define DDA1	1
#define DDA0	0

/* Pointer registers (same for all AVR devices so far) */
#define XL r26
#define XH r27
#define YL r28
#define YH r29
#define ZL r30
#define ZH r31

/* Last memory addresses */
#define RAMEND		0x15F
#define XRAMEND		0x15F
#define E2END		0x1FF
#define FLASHEND	0x1FFF

#endif  /* __IO8534 */
