/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/
#include <stdlib.h>
#include "demogra/demogra1.h"

void Form1::init()
{
    demo = new demographie("demo.csv");
    richtext = new MyRichText();
    Frame4->setLineWidth( 1 );
    dp = new diagramm(670,680,Frame4);
    LineEdit1->setText("1.3");
    LineEdit2->setText("0");
    LineEdit6->setText("0");
    LineEdit3->setText("1");
    long int m=(long int)demo->get_m();
    long int f=(long int)demo->get_f();
    QString s_m;
    QString s_f;
    s_m.setNum(m);
    s_f.setNum(f);
    LineEdit4->setText(s_m);
    LineEdit5->setText(s_f);
    demo->gebset(1.3);
    demo->mig_plus(0);
    dp->set_fields(demo->f, demo->m,0);
    dp->paintEvent((QPaintEvent *) NULL);
    step1=0;
}

void Form1::help()
{  
    richtext->resize( 500, 380 );	
    richtext->setCaption( "Help-Window" );
    richtext->show();
}

void Form1::save()
{
    demo->save("simulation.dat");
}

void Form1::step()
{
    QString t=LineEdit3->text();
    int it=atoi(t.ascii());
    if(it<1 || it>100){
	QMessageBox::warning( this, "step"," the simulationtime must be between (1..100)!");
	return;	
    }
    QString geb=LineEdit1->text();
    float fgeb=atof(geb.ascii());
    
    QString mig=LineEdit2->text();	
    float fmig=atof(mig.ascii());
    if(fmig<0 || fmig>5000000){
	QMessageBox::warning( this, "step","the imigration must be in (0..5000000)!");
	return;	
    }	
    demo->mig_plus(fmig);
    
    QString migi=LineEdit6->text();	
    fmig=atof(migi.ascii());	
    if(fmig<0 || fmig>5000000){
	QMessageBox::warning( this, "step","the emigration must be in (0..5000000)!");
	return;	
    }	
    demo->mig_minus(-fmig);     

    if(fgeb<0 || fgeb>10){
	QMessageBox::warning( this, "step","the birthrate must be between (0..10)!");
	return;
    }

    demo->gebset(fgeb);
    
    for(int i=0; i<it; i++) {
	demo->step();
    }
    step1+=it;
    dp->set_fields(demo->f, demo->m,step1);
    dp->paintEvent((QPaintEvent *) NULL);
    long int m=(long int)demo->get_m();
    long int f=(long int)demo->get_f();
    QString s_m;
    QString s_f;
    s_m.setNum(m);
    s_f.setNum(f);
    LineEdit4->setText(s_m);
    LineEdit5->setText(s_f);
}	

void Form1::Reset()
{
    demo->reset();
    step1=0;
    QString geb=LineEdit1->text();
    float fgeb=atof(geb.ascii());
    QString mig=LineEdit2->text();
    float fmig=atof(mig.ascii());
    if(fmig<0 || fmig>1000000){
	QMessageBox::warning( this, "step","the imigration must be in (0..1000000)!");
	return;	
    }	
    demo->mig_plus(fmig); 
    
    QString migi=LineEdit6->text();	
    fmig=atof(migi.ascii());		
    if(fmig<0 || fmig>1000000){
	QMessageBox::warning( this, "step","the emigration must be in (0..1000000)!");
	return;	
    }	
    demo->mig_minus(-fmig);
    
    QString t=LineEdit3->text();
    int it=atoi(t.ascii());
    if(fgeb<0 || fgeb>10){
	QMessageBox::warning( this, "step","the birthrate must be between (0..10)!");
	return;
    }
    if(it<1 || it>100){
	QMessageBox::warning( this, "step"," the simulationtime must be between (1..100)!");
	return;	
    }
    demo->gebset(fgeb);
    dp->set_fields(demo->f, demo->m,step1);
    dp->paintEvent((QPaintEvent *) NULL);
    long int m=(long int)demo->get_m();
    long int f=(long int)demo->get_f();
    QString s_m;
    QString s_f;
    s_m.setNum(m);
    s_f.setNum(f);
    LineEdit4->setText(s_m);
    LineEdit5->setText(s_f);
}
