/** ********************************************************************
Disclaimer
This example code is provided "AS IS" without warranties of any kind.
Use it at your Risk!

SSLConnection class that will holds the common traits for both the 
client and the server relay. The client and server proxy will inherit from this 
class 

Chianglin Jan 2003

************************************************************ */


import java.io.*;
import java.net.*;
import javax.net.ssl.*;
import java.security.*;



public class SSLConnection {


private SSLContext ctx ;
private KeyStore mykey , mytrust ;
private String key, trust ;


//Default constructor takes the filename of the keystore and truststore , 
//the password of the stores and the password of the private key
public SSLConnection(String key , String trust , char[] storepass, char[]
keypass) {
this.key = key;
this.trust = trust ;
initSSLContext(storepass , keypass );
}




public void initKeyStores(String key , String trust , char[] storepass){
/* mykey holding my own certificate and private key, mytrust holding all the 
certificates that I trust */
   try { 
 	//get instances of the Sun JKS keystore
 	mykey = KeyStore.getInstance("JKS" , "SUN");
	mytrust = KeyStore.getInstance("JKS", "SUN");

	//load the keystores
	mykey.load(new FileInputStream(key)  ,storepass);
	mytrust.load(new FileInputStream(trust) ,storepass );

	}
   catch(Exception e) {
   	System.err.println(e.getMessage());
	System.exit(1);
	}
   

}



public void initSSLContext(char[] storepass , char[] keypass) { 
    try {   
    ctx = SSLContext.getInstance("TLSv1" , "SunJSSE");
    initKeyStores(key , trust , storepass) ;
    //Create the key and trust manager factories for handing the cerficates 
    //in the key and trust stores
    TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509" , 
    "SunJSSE");
    tmf.init(mytrust);
    
    KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509" , 
    "SunJSSE");
    kmf.init(mykey , keypass);
    
    ctx.init(kmf.getKeyManagers() , tmf.getTrustManagers() ,null) ;
    }
    catch(Exception e) {
    System.err.println(e.getMessage());
    System.exit(1);
    }

}

public SSLContext getMySSLContext() {
return ctx ;
}

}
