/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class GCalc
extends Applet
implements ActionListener,
ItemListener {
    String notice = "GCalc\nVersion 1.501\nCopyright 1999-2001 Jiho Kim\n";
    TextField textfield1;
    Graph graph1;
    Button axisButton;
    Button scoresButton;
    Button gridButton;
    Button dotsButton;
    Button traceButton;
    Button standardZoomButton;
    Button trigZoomButton;
    Button squareZoomButton;
    Button graphFitZoomButton;
    Button zoomInButton;
    Button zoomOutButton;
    TextField xZoom;
    TextField yZoom;
    TextField xminTF;
    TextField xmaxTF;
    TextField xsclTF;
    TextField yminTF;
    TextField ymaxTF;
    TextField ysclTF;
    Button resetButton;
    Button previousButton;
    Button nextButton;
    Button regraphButton;
    Choice colorChoice;
    String[] colorString;
    Color[] colorArray;
    StringList sl;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("GCalc");
        GCalc gCalc = new GCalc();
        gCalc.init();
        gCalc.start();
        frame.addWindowListener(frame);
        frame.add("Center", gCalc);
        ((Component)frame).setSize(700, 430);
        frame.setResizable(false);
        frame.show();
    }

    public void init() {
        this.initApplet();
        this.initGUI();
    }

    void initApplet() {
        this.setVisible(true);
        this.setBackground(new Color(240, 240, 200));
        this.setLayout(new BorderLayout(5, 5));
        this.graph1 = new Graph(this, 460, 330);
        this.colorString = new String[5];
        this.colorArray = new Color[5];
        this.colorString[0] = "Blue";
        this.colorArray[0] = Color.blue;
        this.colorString[1] = "Green";
        this.colorArray[1] = Color.green.darker();
        this.colorString[2] = "Purple";
        this.colorArray[2] = Color.magenta.darker();
        this.colorString[3] = "Brown";
        this.colorArray[3] = Color.orange.darker();
        this.colorString[4] = "Black";
        this.colorArray[4] = Color.black;
        this.sl = new StringList();
    }

    void initGUI() {
        Font font = new Font("Courier", 0, 12);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 5, 1, 0));
        this.axisButton = new Button("Axis ON");
        this.scoresButton = new Button("Scale ON");
        this.gridButton = new Button("Grid OFF");
        this.dotsButton = new Button("Continuous");
        this.traceButton = new Button("Trace OFF");
        this.axisButton.addActionListener(this);
        this.scoresButton.addActionListener(this);
        this.gridButton.addActionListener(this);
        this.dotsButton.addActionListener(this);
        this.traceButton.addActionListener(this);
        panel.add(this.axisButton);
        panel.add(this.scoresButton);
        panel.add(this.gridButton);
        panel.add(this.dotsButton);
        panel.add(this.traceButton);
        Panel panel2 = new Panel();
        this.textfield1 = new TextField("", 42);
        this.textfield1.setFont(new Font("Courier", 0, 12));
        this.textfield1.setBackground(Color.white);
        this.textfield1.addActionListener(this);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout(5, 5));
        panel3.add("North", this.textfield1);
        panel3.add("Center", this.graph1);
        panel3.add("South", panel);
        panel2.add(panel3);
        this.add("West", panel2);
        this.standardZoomButton = new Button("Standard Zoom");
        this.trigZoomButton = new Button("Trig Zoom");
        this.squareZoomButton = new Button("Square Zoom");
        this.graphFitZoomButton = new Button("Graph-Fit Zoom");
        this.standardZoomButton.addActionListener(this);
        this.trigZoomButton.addActionListener(this);
        this.squareZoomButton.addActionListener(this);
        this.graphFitZoomButton.addActionListener(this);
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(4, 1));
        panel4.add(this.standardZoomButton);
        panel4.add(this.trigZoomButton);
        panel4.add(this.squareZoomButton);
        panel4.add(this.graphFitZoomButton);
        this.zoomInButton = new Button("Zoom In");
        this.zoomOutButton = new Button("Zoom Out");
        this.xZoom = new TextField("2.0");
        this.yZoom = new TextField("2.0");
        this.xZoom.setFont(font);
        this.yZoom.setFont(font);
        this.xZoom.setBackground(Color.white);
        this.yZoom.setBackground(Color.white);
        this.zoomInButton.addActionListener(this);
        this.zoomOutButton.addActionListener(this);
        this.xZoom.addActionListener(this);
        this.yZoom.addActionListener(this);
        Panel panel5 = new Panel();
        panel5.setLayout(new GridLayout(4, 1));
        panel5.add(this.zoomInButton);
        panel5.add(this.zoomOutButton);
        panel5.add(this.xZoom);
        panel5.add(this.yZoom);
        this.xminTF = new TextField("", 20);
        this.xmaxTF = new TextField("", 20);
        this.xsclTF = new TextField("", 20);
        this.yminTF = new TextField("", 20);
        this.ymaxTF = new TextField("", 20);
        this.ysclTF = new TextField("", 20);
        this.xminTF.addActionListener(this);
        this.xmaxTF.addActionListener(this);
        this.xsclTF.addActionListener(this);
        this.yminTF.addActionListener(this);
        this.ymaxTF.addActionListener(this);
        this.ysclTF.addActionListener(this);
        this.xminTF.setFont(font);
        this.xmaxTF.setFont(font);
        this.xsclTF.setFont(font);
        this.yminTF.setFont(font);
        this.ymaxTF.setFont(font);
        this.ysclTF.setFont(font);
        this.xminTF.setBackground(Color.white);
        this.xmaxTF.setBackground(Color.white);
        this.xsclTF.setBackground(Color.white);
        this.yminTF.setBackground(Color.white);
        this.ymaxTF.setBackground(Color.white);
        this.ysclTF.setBackground(Color.white);
        Panel panel6 = new Panel();
        Panel panel7 = new Panel();
        Panel panel8 = new Panel();
        Panel panel9 = new Panel();
        Panel panel10 = new Panel();
        Panel panel11 = new Panel();
        panel6.setLayout(new BorderLayout());
        panel7.setLayout(new BorderLayout());
        panel8.setLayout(new BorderLayout());
        panel9.setLayout(new BorderLayout());
        panel10.setLayout(new BorderLayout());
        panel11.setLayout(new BorderLayout());
        panel6.add("Center", new Label("XMin", 0));
        panel6.add("East", this.xminTF);
        panel7.add("Center", new Label("XMax", 0));
        panel7.add("East", this.xmaxTF);
        panel8.add("Center", new Label("XScale", 0));
        panel8.add("East", this.xsclTF);
        panel9.add("Center", new Label("YMin", 0));
        panel9.add("East", this.yminTF);
        panel10.add("Center", new Label("YMax", 0));
        panel10.add("East", this.ymaxTF);
        panel11.add("Center", new Label("YScale", 0));
        panel11.add("East", this.ysclTF);
        Panel panel12 = new Panel();
        panel12.setLayout(new GridLayout(6, 1));
        panel12.add(panel6);
        panel12.add(panel7);
        panel12.add(panel8);
        panel12.add(panel9);
        panel12.add(panel10);
        panel12.add(panel11);
        this.resetButton = new Button("RESET");
        this.previousButton = new Button("Prev");
        this.nextButton = new Button("Next");
        this.previousButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.colorChoice = new Choice();
        this.colorChoice.addItemListener(this);
        int n = 0;
        while (n < this.colorString.length) {
            this.colorChoice.add(this.colorString[n]);
            ++n;
        }
        Panel panel13 = new Panel();
        panel13.setLayout(new GridLayout(2, 2, 5, 5));
        panel13.add(this.previousButton);
        panel13.add(this.nextButton);
        panel13.add(this.colorChoice);
        panel13.add(this.resetButton);
        Panel panel14 = new Panel();
        Panel panel15 = new Panel();
        Panel panel16 = new Panel();
        Panel panel17 = new Panel();
        panel14.setLayout(new BorderLayout(5, 5));
        panel16.setLayout(new GridLayout(1, 2, 5, 0));
        panel15.setLayout(new BorderLayout(5, 5));
        panel17.setLayout(new BorderLayout(5, 5));
        panel14.add("North", panel13);
        panel16.add(panel4);
        panel16.add(panel5);
        panel14.add("Center", panel16);
        panel14.add("South", panel15);
        panel15.add("North", panel12);
        Panel panel18 = new Panel();
        panel18.setLayout(new BorderLayout(5, 5));
        panel18.add("North", panel14);
        panel18.add("Center", panel15);
        panel17.add("Center", panel18);
        panel17.add("East", new Canvas());
        this.add("East", panel17);
        this.add("North", new Canvas());
        this.add("South", new Canvas());
        this.updateRangeTF();
    }

    public void start() {
        System.out.println(this.notice);
        this.graph1.clearGraph();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component = (Component)actionEvent.getSource();
        if (component == this.textfield1) {
            this.processUserInput(this.textfield1.getText());
        } else if (component == this.axisButton) {
            boolean bl = this.graph1.axis = !this.graph1.axis;
            if (this.graph1.axis) {
                this.axisButton.setLabel("Axis ON");
            } else {
                this.axisButton.setLabel("Axis OFF");
            }
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
        } else if (component == this.scoresButton) {
            boolean bl = this.graph1.scores = !this.graph1.scores;
            if (this.graph1.scores) {
                this.scoresButton.setLabel("Scores ON");
            } else {
                this.scoresButton.setLabel("Scores OFF");
            }
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
        } else if (component == this.gridButton) {
            boolean bl = this.graph1.grid = !this.graph1.grid;
            if (this.graph1.grid) {
                this.gridButton.setLabel("Grid ON");
            } else {
                this.gridButton.setLabel("Grid OFF");
            }
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
        } else if (component == this.dotsButton) {
            boolean bl = this.graph1.dots = !this.graph1.dots;
            if (this.graph1.dots) {
                this.dotsButton.setLabel("Discrete");
            } else {
                this.dotsButton.setLabel("Continuous");
            }
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
        } else if (component == this.traceButton) {
            boolean bl = this.graph1.trace = !this.graph1.trace;
            if (this.graph1.trace) {
                this.traceButton.setLabel("Trace ON");
                this.graph1.traceMode();
            } else {
                this.traceButton.setLabel("Trace OFF");
            }
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
        } else if (component == this.graphFitZoomButton) {
            if (this.graphFitZoomButton.getLabel().equals("Graph-Fit Zoom")) {
                this.graphFitZoomButton.setLabel("In progress");
                double d = Double.MIN_VALUE;
                double d2 = Double.MAX_VALUE;
                PostfixList postfixList = this.graph1.getList();
                int n = 0;
                while (n < postfixList.List.size()) {
                    PostfixListNode postfixListNode = (PostfixListNode)postfixList.List.elementAt(n);
                    if (postfixListNode.drawn && postfixListNode.pf != null) {
                        double d3 = 0.0;
                        while (d3 <= (double)this.graph1.xpixels) {
                            double d4 = postfixList.get(n).evaluate((this.graph1.xmax - this.graph1.xmin) * d3 / (double)this.graph1.xpixels + this.graph1.xmin);
                            if (d4 < d2) {
                                d2 = d4;
                            }
                            if (d4 > d) {
                                d = d4;
                            }
                            d3 += 0.25;
                        }
                    }
                    ++n;
                }
                if (d != Double.MIN_VALUE && d2 != Double.MAX_VALUE && d != d2 && d2 != Double.NEGATIVE_INFINITY && d != Double.POSITIVE_INFINITY) {
                    this.graph1.changeRange(this.graph1.xmin, this.graph1.xmax, this.graph1.xscl, d2, d, this.graph1.yscl);
                    this.graph1.clearGraph();
                    this.graph1.drawPostfix();
                }
            } else {
                this.graphFitZoomButton.setLabel("In progress");
                this.graph1.fitToZoomBox();
                this.graph1.drawPostfix();
            }
            this.updateRangeTF();
            this.graphFitZoomButton.setLabel("Graph-Fit Zoom");
        } else if (component == this.standardZoomButton) {
            this.standardZoomButton.setLabel("In progress");
            this.graph1.changeRange(-10.0, 10.0, 1.0, -10.0, 10.0, 1.0);
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
            this.updateRangeTF();
            this.standardZoomButton.setLabel("Standard Zoom");
        } else if (component == this.trigZoomButton) {
            this.trigZoomButton.setLabel("In progress");
            this.graph1.changeRange(-7.853981633974483, 7.853981633974483, 1.5707963267948966, -4.0, 4.0, 1.0);
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
            this.updateRangeTF();
            this.trigZoomButton.setLabel("Trig Zoom");
        } else if (component == this.squareZoomButton) {
            this.squareZoomButton.setLabel("In progress");
            double d = (double)this.graph1.ypixels * (this.graph1.xmax - this.graph1.xmin) / 2.0 / (double)this.graph1.xpixels;
            this.graph1.changeRange(this.graph1.xmin, this.graph1.xmax, this.graph1.xscl, this.graph1.yavg - d, this.graph1.yavg + d, this.graph1.yscl);
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
            this.updateRangeTF();
            this.squareZoomButton.setLabel("Square Zoom");
        } else if (component == this.zoomInButton) {
            this.zoomInButton.setLabel("In progress");
            this.setZoomValues();
            double d = (this.graph1.xmax - this.graph1.xmin) / this.graph1.xzoom / 2.0;
            double d5 = (this.graph1.ymax - this.graph1.ymin) / this.graph1.yzoom / 2.0;
            this.graph1.changeRange(this.graph1.xavg - d, this.graph1.xavg + d, this.graph1.xscl, this.graph1.yavg - d5, this.graph1.yavg + d5, this.graph1.yscl);
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
            this.updateRangeTF();
            this.updateZoomTF();
            this.zoomInButton.setLabel("Zoom In");
        } else if (component == this.zoomOutButton) {
            this.zoomOutButton.setLabel("In progress");
            this.setZoomValues();
            double d = (this.graph1.xmax - this.graph1.xmin) * this.graph1.xzoom / 2.0;
            double d6 = (this.graph1.ymax - this.graph1.ymin) * this.graph1.yzoom / 2.0;
            this.graph1.changeRange(this.graph1.xavg - d, this.graph1.xavg + d, this.graph1.xscl, this.graph1.yavg - d6, this.graph1.yavg + d6, this.graph1.yscl);
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
            this.updateRangeTF();
            this.updateZoomTF();
            this.zoomOutButton.setLabel("Zoom Out");
        } else if (component == this.xmaxTF || component == this.xminTF || component == this.ymaxTF || component == this.yminTF || component == this.xsclTF || component == this.ysclTF) {
            this.setRangeValues();
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
        } else if (component == this.resetButton) {
            this.setRangeValues();
            this.graph1.clearList();
            this.graph1.clearGraph();
            this.textfield1.setText("");
            this.colorChoice.select(0);
            this.sl.clear();
        } else if (component == this.previousButton) {
            this.textfield1.setText(this.sl.getPrev());
        } else if (component == this.nextButton) {
            this.textfield1.setText(this.sl.getNext());
        }
    }

    void processUserInput(String string) {
        int n;
        String string2 = string.trim().toLowerCase();
        String string3 = "";
        int n2 = 0;
        if (string2.equals("clear")) {
            n2 = 3;
            this.graph1.clearList();
            this.graph1.clearGraph();
            this.textfield1.setText("");
            this.colorChoice.select(0);
            this.sl.clear();
            System.gc();
        } else if (string2.equals("axis")) {
            n2 = 1;
            this.graph1.axis = !this.graph1.axis;
            this.graph1.clearGraph();
            this.textfield1.setText("");
        } else if (string2.equals("tick")) {
            n2 = 1;
            this.graph1.scores = !this.graph1.scores;
            this.graph1.clearGraph();
            this.textfield1.setText("");
        } else if (string2.equals("dots")) {
            n2 = 1;
            this.graph1.dots = !this.graph1.dots;
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
            this.textfield1.setText("");
        } else if (string2.equals("grid")) {
            n2 = 1;
            this.graph1.grid = !this.graph1.grid;
            this.graph1.clearGraph();
            this.textfield1.setText("");
        } else if (string2.equals("prev")) {
            n2 = 1;
            this.textfield1.setText(this.sl.getPrev());
        } else if (string2.equals("next")) {
            n2 = 1;
            this.textfield1.setText(this.sl.getNext());
        } else if (string2.startsWith("~")) {
            n2 = 1;
            n = 0;
            try {
                Integer n3 = Integer.valueOf(string2.substring(1));
                n = n3;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.graph1.remove(n);
            this.graph1.clearGraph();
            this.graph1.drawPostfix();
            this.textfield1.setText("");
        } else if (string2.startsWith("list")) {
            n2 = 1;
            this.graph1.getList().showInfix();
            this.textfield1.setText("");
        } else if (string2.startsWith("#")) {
            n2 = 1;
            n = 0;
            try {
                Integer n4 = Integer.valueOf(string2.substring(1));
                n = n4;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.textfield1.setText(this.graph1.getList().get((int)n).infixStr);
        }
        Postfix postfix = null;
        if (n2 == 0) {
            long l = System.currentTimeMillis();
            n2 = 2;
            this.sl.add(string2);
            this.sl.resetCursor();
            this.setRangeValues();
            postfix = new Postfix(string2);
            string3 = postfix.getStack().showAll();
            this.graph1.drawPostfix(postfix, this.colorArray[this.colorChoice.getSelectedIndex()]);
            this.graph1.drawPostfix();
            this.textfield1.setText("");
            this.colorChoice.select((this.colorChoice.getSelectedIndex() + 1) % this.colorArray.length);
        }
        if (n2 == 2 && !string3.equals("")) {
            System.out.println("INFIX: " + string2);
            System.out.println("POSTFIX: " + string3);
            System.out.println();
        }
    }

    public void setZoomValues() {
        double d;
        double d2;
        Double d3;
        try {
            d3 = Double.valueOf(this.xZoom.getText());
            d2 = d3;
        }
        catch (NumberFormatException numberFormatException) {
            d2 = this.graph1.xzoom;
        }
        try {
            d3 = Double.valueOf(this.yZoom.getText());
            d = d3;
        }
        catch (NumberFormatException numberFormatException) {
            d = this.graph1.yzoom;
        }
        if (d2 * d != 0.0) {
            this.graph1.yzoom = Math.abs(d);
            this.graph1.xzoom = Math.abs(d2);
            this.updateZoomTF();
        }
    }

    public void setRangeValues() {
        double d;
        Postfix postfix = new Postfix(this.xminTF.getText());
        double d2 = postfix.isConstant() ? postfix.evaluate(0.0) : this.graph1.xmin;
        postfix = new Postfix(this.xmaxTF.getText());
        double d3 = postfix.isConstant() ? postfix.evaluate(0.0) : this.graph1.xmax;
        postfix = new Postfix(this.xsclTF.getText());
        double d4 = postfix.isConstant() ? postfix.evaluate(0.0) : this.graph1.xscl;
        postfix = new Postfix(this.yminTF.getText());
        double d5 = postfix.isConstant() ? postfix.evaluate(0.0) : this.graph1.ymin;
        postfix = new Postfix(this.ymaxTF.getText());
        double d6 = postfix.isConstant() ? postfix.evaluate(0.0) : this.graph1.ymax;
        postfix = new Postfix(this.ysclTF.getText());
        double d7 = d = postfix.isConstant() ? postfix.evaluate(0.0) : this.graph1.yscl;
        if (d3 > d2 && d6 > d5) {
            this.graph1.changeRange(d2, d3, d4, d5, d6, d);
            this.updateRangeTF();
        }
    }

    void updateRangeTF() {
        this.xmaxTF.setText("" + this.graph1.xmax);
        this.xminTF.setText("" + this.graph1.xmin);
        this.xsclTF.setText("" + this.graph1.xscl);
        this.ymaxTF.setText("" + this.graph1.ymax);
        this.yminTF.setText("" + this.graph1.ymin);
        this.ysclTF.setText("" + this.graph1.yscl);
    }

    void updateZoomTF() {
        this.xZoom.setText("" + this.graph1.xzoom);
        this.yZoom.setText("" + this.graph1.yzoom);
    }
}

