#!/bin/sh
#
# corrector.sh - Busca en varios archivos xml (utf-8) por palabras no conocidas
#                Rafael Ignacio Zurita, 2006
#
# Uso: 
#      corrector.sh [-v] *xml
# 

tf=`mktemp`  # temp file

( cat $* | 
 while read line ; do
   for i in $line ; do 
       echo $i 
   done
 done ) | tr [A-Z] [a-z] | sort | uniq |
          aspell -d es --encoding=utf-8 --mode=sgml list |
          aspell --encoding=utf-8 --mode=sgml list |
          sort | uniq >> $tf  

if [ "$1" == "-v" ] ; then
  for i in `cat $tf ` ; do
    echo -n $i : 
    echo -n `grep -i -c $i $* | grep -v :0`
    echo .
  done
fi
  
cp $tf ./palabras_desconocidas.log &&
echo "Un listado de palabras desconocidas ha quedado en ./palabras_desconocidas.log"

